#!/bin/bash

# 定义模型名称数组
ll_weights=(1)
# 定义起始GPU索引
gpu_0_index=2


# 遍历模型名称
for ll_weight in "${ll_weights[@]}"; do
    # 替换模型名中的'/'为'_'，以便用作文件名
    sanitized_model_name=${model_name//\//_}
    
    # 构建并运行命令
    echo "Running model on GPU $gpu_0_index..."
    CUDA_VISIBLE_DEVICES=$gpu_0_index nohup python -u main.py --sum_avg "avg" --test_csv "cache/test_success_text_llama3_test.csv" --valid_csv "cache/valid_success_text_llama3_test.csv" --check_val_every_n_epoch 5 --n_samples 4 --epochs 30 --ll-weight $ll_weight --use-buffer 0.25 --logZ_init 5 --pretrained_model "meta-llama/Meta-Llama-3-8B-Instruct" > "./logs/10_training_llama3_test.txt" 2>&1 &
    # 等待一段时间再启动下一个模型的训练，确保命令已经在后台运行
    # 你可以根据需要调整sleep的时间
    sleep 5
done
echo "All models are running in background."
